//Initialization steppable to polarize the membrane and to initialize the clusterData, needs  pickeltrackerplugin and boundarytrackerplugin, neighborOrder and ClusterVolume form XML
#include <CompuCell3D/Potts3D/CellInventory.h>
#include <CompuCell3D/Automaton/Automaton.h>
#include <CompuCell3D/Boundary/BoundaryStrategy.h>

#include <CompuCell3D/Potts3D/Cell.h>
#include <Utils/Coordinates3D.h>

using namespace CompuCell3D;
#include <BasicUtils/BasicString.h>
#include <BasicUtils/BasicException.h>
#include <BasicUtils/BasicClassAccessor.h>

#include <CompuCell3D/Simulator.h>
#include <CompuCell3D/Potts3D/Potts3D.h>
#include <CompuCell3D/Field3D/Field3D.h>
#include <CompuCell3D/Field3D/WatchableField3D.h>
#include <CompuCell3D/plugins/PixelTracker/PixelTrackerPlugin.h>
#include <CompuCell3D/plugins/PixelTracker/BoundaryPixelTrackerPlugin.h>

#include <vector>
#include <set>
#include <map>
#include <algorithm>

#include <stdio.h>
#include <time.h>
#include <iostream>
using namespace std;


#include "MembranePolarizationFluidSteppable.h"
#include "ClusterData.h"

MembranePolarizationFluidSteppable::MembranePolarizationFluidSteppable(){}

MembranePolarizationFluidSteppable::~MembranePolarizationFluidSteppable() {
}


void MembranePolarizationFluidSteppable::init(Simulator *simulator, CC3DXMLElement *_xmlData){
cerr<<"*****************init************="<<endl;	
  potts = simulator->getPotts();
  sim=simulator;
  automaton = potts->getAutomaton();
  fieldG = (WatchableField3D<CellG *> *)potts->getCellFieldG();
  cellInventoryPtr = & potts->getCellInventory();

  update(_xmlData,true);

 // define a new data-class (clusterData) for each cell:	
    BasicClassAccessorBase * clusterDataAccessorPtr=&clusterDataAccessor;
	potts->getCellFactoryGroupPtr()->registerClass(clusterDataAccessorPtr); //this is to register the BasicclassAccessor to the large factory file


    //check if these plugins have been done and do them if not
	bool pixelTrackerAlreadyRegisteredFlag;
	pixelTrackerPlugin=(PixelTrackerPlugin*)Simulator::pluginManager.get("PixelTracker",&pixelTrackerAlreadyRegisteredFlag);
	if (!pixelTrackerAlreadyRegisteredFlag){
		pixelTrackerPlugin->init(simulator);
	}

	bool boundaryPixelTrackerAlreadyRegisteredFlag;
	boundaryPixelTrackerPlugin=(BoundaryPixelTrackerPlugin*)Simulator::pluginManager.get("BoundaryPixelTracker",&boundaryPixelTrackerAlreadyRegisteredFlag);
	if (!boundaryPixelTrackerAlreadyRegisteredFlag){
		boundaryPixelTrackerPlugin->init(simulator);
	}
        
        bool clusterDataTrackerAlreadyRegisteredFlag;
	clusterDataTrackerPlugin=(ClusterDataTrackerPlugin*)Simulator::pluginManager.get("ClusterDataTrackerPlugin",&clusterDataTrackerAlreadyRegisteredFlag);
	if (!clusterDataTrackerAlreadyRegisteredFlag){
		clusterDataTrackerPlugin->init(simulator,_xmlData);
	}
  simulator->registerSteerableObject(this);
   
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void MembranePolarizationFluidSteppable::extraInit(Simulator *simulator)
{ 
}

void MembranePolarizationFluidSteppable::start()
{ //to initialize clusterData for each cell
    set<CellG*> CellInventoryList;
    CellInventory::cellInventoryIterator cii;
    //iterate over cells and initialize clusterData for each cell (different for cells of type cell than other types within clusterdatatracker)
    for (cii=cellInventoryPtr->cellInventoryBegin(); cii!=cellInventoryPtr->cellInventoryEnd(); ++cii)
        { 
        CellG *cell;
	cell=cellInventoryPtr->getCell(cii);
        clusterDataTrackerPlugin->insertCellInCluster(cell);   //here we load clusterDataTrackerPlugin to initialize clusterdata for each cell          
        }  
    //clusterDataTrackerPlugin->printClusterIdCells();
    set<long int> clusterIdList=clusterDataTrackerPlugin->getClusterIdsList();
    set<long int> ::iterator clusterIdListIt;
    for ( clusterIdListIt=clusterIdList.begin() ; clusterIdListIt != clusterIdList.end(); ++clusterIdListIt )
        {
        long int ownClusterId= *clusterIdListIt;   
        membraneData cellMembraneData=pixelsInMembrane(ownClusterId, false); 
        clusterDataTrackerPlugin->setBoundaryTrackerList(ownClusterId, cellMembraneData.membranePixelSet);
        }
}
   

void MembranePolarizationFluidSteppable::step(const unsigned int currentStep)
{ //cerr<<"1*****************step************="<<endl;
      
    //make a dictionary of the clusters, key=clusternumber and value=cells in cluster. Only clusters of endothelial cells are added to the dictionary
    //map<long,set<CellG*> > clusterMap=makeClusterMap();
    
    //clusterDataTrackerPlugin->printClusterIdCells();
    //clusterDataTrackerPlugin->printTotalTargetVolume();
    //clusterDataTrackerPlugin->printTotalCellVolume();
    //clusterDataTrackerPlugin->printTotalTargetVolumeError();
    //iterate over the clusters and perform membrane polarization and vesicle secretion if of type EC
    set<long int> clusterIdList=clusterDataTrackerPlugin->getClusterIdsList();
    set<long int> ::iterator clusterIdListIt;
    for ( clusterIdListIt=clusterIdList.begin() ; clusterIdListIt != clusterIdList.end(); ++clusterIdListIt )
        {
        long int ownClusterId= *clusterIdListIt;
        //cerr<<"cluster Id list ="<<ownClusterId<<" targetV="<<clusterDataTrackerPlugin->getClusterTargetVolume(ownClusterId)<<endl;
        if(clusterDataTrackerPlugin->getIfEC(ownClusterId)||clusterDataTrackerPlugin->getIfPericyte(ownClusterId)) //if of type EC
            { 
            //cerr<<"clusterId= "<<ownClusterId<<" TV= "<<clusterDataTrackerPlugin->getClusterTargetVolume(ownClusterId)<< " LV= "<<clusterDataTrackerPlugin->getClusterLambdaVolume(ownClusterId)<<" vol="<<clusterDataTrackerPlugin->getClusterVolume(ownClusterId)<<endl;                               
                        //grow after division
//              if ( clusterDataTrackerPlugin->getClusterTargetVolume(ownClusterId)<=790)
//                  clusterDataTrackerPlugin->addClusterTargetVolume(ownClusterId,10);
             
              if (currentStep>=initializingStep)  
                {   
            vesicleSecretion(ownClusterId); //secrete vesicles in membrane
            
             membraneData cellMembraneData=pixelsInMembraneFast(ownClusterId, true); //typedef struct to store which in membrane and which could become vesicles.
             cellMembraneData=MPbyBM(ownClusterId, cellMembraneData); //do membrane polarization based on BM contact, thus no lateral yet
             bool polarization=cellMembraneData.polarization;
           vesicleCreation(ownClusterId, cellMembraneData); //create vesicles from membrane internalization         
            if (polarization)
                {
                MPlateral(ownClusterId, cellMembraneData); //Do lateral adjustments in membrane polarization
                }
            else
                {
                depolarization(ownClusterId, cellMembraneData); //depolarize if no contact with BM
                //cavitation: clusterDataTrackerPlugin->setClusterTargetVolume(ownClusterId)-=10;
                }       
            }
        }
    }
}


map< long,set<CellG*> >  MembranePolarizationFluidSteppable::makeClusterMap()
{ //to make dictionary of EC cells in a cluster 
    //cerr<<"2*****************makeClusterMap************="<<endl;
    map< long,set<CellG*> > clusterList;
    CellInventory::cellInventoryIterator cii;

    //iterate over cells and make a dictionary for endothelial cells, with key=clusterId and value= cells within cluster
    for (cii=cellInventoryPtr->cellInventoryBegin(); cii!=cellInventoryPtr->cellInventoryEnd(); ++cii)
        {
        CellG *cell;
	    cell=cellInventoryPtr->getCell(cii);
        
        if (cell->volume)
            {
            //if ((cell->type==automaton->getTypeId("cell")) || (cell->type==automaton->getTypeId("basolat")) || (cell->type==automaton->getTypeId("apical")) || (cell->type==automaton->getTypeId("vesicle"))) 
            if ((cell->type==automaton->getTypeId("cell")) || (cell->type==automaton->getTypeId("basolat")) || (cell->type==automaton->getTypeId("apical")) || (cell->type==automaton->getTypeId("vesicle"))|| (cell->type==automaton->getTypeId("vacuole")))
                {
                
                //if clusterId not in list, than this is first cell as key
                if ( clusterList.find(cell->clusterId) == clusterList.end() ) 
                    {
                    set<CellG*> cellsInClusterList;
                    cellsInClusterList.insert(cell);
                    clusterList.insert( pair < long,set<CellG*> >((cell->clusterId),cellsInClusterList));
                    }
                //if clusterId is in list, than ask for the celllist and add this cell, give this as key
                else
                    {
                    set<CellG*> cellsInClusterList=clusterList.find(cell->clusterId)->second;
                    cellsInClusterList.insert(cell);
                    clusterList[cell->clusterId]=cellsInClusterList;
                    }  
                }       
            }
        //else
            //{cerr<<"No VOLUME!! "<<cell<<" id "<< cell->id<<" type "<< (int) cell->type<<" volume "<< cell->volume<<endl;}
        }

    //print which cells are in clusters
    //double cellCount;
    map<long,set<CellG*> >::iterator clusterIt;
    for ( clusterIt=clusterList.begin() ; clusterIt != clusterList.end(); ++clusterIt )
        {
        cerr<<"##########2clusterID="<<(*clusterIt).first<<endl;
        set<CellG*> ::iterator cellInClusterIt;
        set<CellG*> cellsInCluster=(*clusterIt).second;
        for ( cellInClusterIt=cellsInCluster.begin() ; cellInClusterIt != cellsInCluster.end(); ++cellInClusterIt )
            {
            CellG *cell= *cellInClusterIt;
            //cellCount+=1;
            cerr<<"##########2clusterCell="<<cell<<" cellid "<<cell->id<<" volume "<<cell->volume<<endl;
            }
        }
    //cerr<<"##########CELLCOUNT="<<cellCount<<endl;

    return clusterList;
}



bool MembranePolarizationFluidSteppable::probabilityPolarization(membraneData cellMembraneData, CellG *fromCell ,char toType )
{ //the type transition is based on a probobality. This function contains the probability and calculates if the transition should take place,
    //cerr<<"10*****************probabilityPolarization************="<<endl;
    bool polarizePixel=false;
    int membranePixelCount=cellMembraneData.membranePixelCount;
    int toBasolCount=cellMembraneData.toBasolCount;
    int polarizedCount=cellMembraneData.polarizedCount;

    double p=0.0;
    //polarized internalized to vesicle
    if ((fromCell->type==automaton->getTypeId("basolat")) && (toType=='v'))
        p = pBtoV;
    if ((fromCell->type==automaton->getTypeId("apical")) && (toType=='v'))
        p = pAtoV;

    // initial polarization dependent of external signal from fibrin
    if ((fromCell->type==automaton->getTypeId("cell")) && (toType=='b'))
        p = pCtoB; //(toBasolCount * toBasolCount) / (membranePixelCount * membranePixelCount);
    if ((fromCell->type==automaton->getTypeId("cell")) && (toType=='a'))
        p = pCtoA; //(toBasolCount * toBasolCount) / (membranePixelCount * membranePixelCount);
    if ((fromCell->type==automaton->getTypeId("pericyte")) && (toType=='b'))
        p = pCtoB; //(toBasolCount * toBasolCount) / (membranePixelCount * membranePixelCount);
    if ((fromCell->type==automaton->getTypeId("pericyte")) && (toType=='a'))
        p = pCtoA; //(toBasolCount * toBasolCount) / (membranePixelCount * membranePixelCount);

    //maintenance of polarization
    if ((fromCell->type==automaton->getTypeId("apical")) && (toType=='a'))
        p = pAtoA; //(polarizedCount * polarizedCount) / ((membranePixelCount * membranePixelCount) + membranePixelCount);
    if ((fromCell->type==automaton->getTypeId("basolat")) && (toType=='b'))
        p = pBtoB; //(polarizedCount * polarizedCount) / ((membranePixelCount * membranePixelCount) + membranePixelCount);
    if ((fromCell->type==automaton->getTypeId("apical")) && (toType=='b'))
        p = pAtoB; //(polarizedCount * polarizedCount) / ((membranePixelCount * membranePixelCount) + membranePixelCount);
    if ((fromCell->type==automaton->getTypeId("basolat")) && (toType=='a'))
        p = pBtoA; //(polarizedCount * polarizedCount) / ((membranePixelCount * membranePixelCount) + membranePixelCount);
    if ((fromCell->type==automaton->getTypeId("vesicle")) && (toType=='a'))
        p = pVtoA; //(polarizedCount * polarizedCount) / ((membranePixelCount * membranePixelCount) + membranePixelCount);
    if ((fromCell->type==automaton->getTypeId("vesicle")) && (toType=='b'))
        p = pVtoB; //(polarizedCount * polarizedCount) / ((membranePixelCount * membranePixelCount) + membranePixelCount);

    //depolarization
    if ((fromCell->type==automaton->getTypeId("apical")) && (toType=='c'))
        p = pAtoC; //(1-((polarizedCount * polarizedCount) / ((membranePixelCount * membranePixelCount) + membranePixelCount)));
    if ((fromCell->type==automaton->getTypeId("basolat")) && (toType=='c'))
        p = pBtoC; //(1-((polarizedCount * polarizedCount) / ((membranePixelCount * membranePixelCount) + membranePixelCount)));
    if ((fromCell->type==automaton->getTypeId("vesicle")) && (toType=='c'))
        p = pVtoC; //(1-((polarizedCount * polarizedCount) / ((membranePixelCount * membranePixelCount) + membranePixelCount)));

    double randomP= rand->getRatio();
    
    if (randomP < p)   
        polarizePixel=true;
    return polarizePixel;
}

MembranePolarizationFluidSteppable::membraneData  MembranePolarizationFluidSteppable::pixelsInMembraneFast(long int ownClusterId, bool listVesicleCandidates)
{ //make a list of pixels at membrane (and count them), for a cluster that contains only one cell or for a polarized cell
   //cerr<<"3*****************pixelsInMembrane************="<<endl;
    
    set<PixelTrackerData> pixelsInMembrane; //list to store the pixelcoordinates of the pixels at the membrane
    pixelsInMembrane.clear();
    set<PixelTrackerData> notAtMembrane; //make a list of the pixels in the cell that are not at the membrane
    notAtMembrane.clear();
    
    pixelsInMembrane=clusterDataTrackerPlugin->getBoundaryTrackerList(ownClusterId); 
    
    map<long int,CellG*> cellsInCluster=clusterDataTrackerPlugin->getCellsInClusterList(ownClusterId); //make a list of cells in this cluster
    map<long int,CellG*> ::iterator cellClusterIt;
    for ( cellClusterIt=cellsInCluster.begin() ; cellClusterIt != cellsInCluster.end(); ++cellClusterIt )
        { 
        //long int keyId=(*cellClusterIt).first;
        CellG *cell=(*cellClusterIt).second;           
        if (listVesicleCandidates)
            {
            if ((cell->type==automaton->getTypeId("basolat")) || (cell->type==automaton->getTypeId("apical")))
                {   
                pixelTrackerAccessorPtr=pixelTrackerPlugin->getPixelTrackerAccessorPtr();
                set<PixelTrackerData> cellPixels=pixelTrackerAccessorPtr->get(cell->extraAttribPtr)->pixelSet;   
            
                //iterate over all the pixels in the cell and store the pixel in notAtMembrane if the pixel is not in pixelsInMembrane
                set<PixelTrackerData>::iterator cellPixelsIt;
                for ( cellPixelsIt = cellPixels.begin();cellPixelsIt != cellPixels.end(); ++cellPixelsIt)
                    {
                    PixelTrackerData pixelData;
                    pixelData=*cellPixelsIt;
                                       
                    if ((pixelsInMembrane.find(pixelData)) == pixelsInMembrane.end())
                        notAtMembrane.insert(pixelData);
                    }
                }
            }
        }

 
    //assign the data to a typedef struct
    membraneData returnStruct;
    returnStruct.membranePixelSet=pixelsInMembrane;
    returnStruct.insidePixelSet=notAtMembrane;
    return returnStruct;
}



MembranePolarizationFluidSteppable::membraneData  MembranePolarizationFluidSteppable::pixelsInMembrane(long int ownClusterId, bool listVesicleCandidates)
{ //make a list of pixels at membrane (and count them), for a cluster that contains only one cell or for a polarized cell
   //cerr<<"3*****************pixelsInMembrane************="<<endl;
    
    set<PixelTrackerData> pixelsInMembrane; //list to store the pixelcoordinates of the pixels at the membrane
    pixelsInMembrane.clear();
    set<PixelTrackerData> notAtMembrane; //make a list of the pixels in the cell that are not at the membrane
    notAtMembrane.clear();
    map<long int,CellG*> cellsInCluster=clusterDataTrackerPlugin->getCellsInClusterList(ownClusterId); //make a list of cells in this cluster
    if (cellsInCluster.size()==1) //not polarized thus can use boundarypixeltracker, since cluster is single cell
        {
        map<long int,CellG*> ::iterator cellClusterIt;
        for ( cellClusterIt=cellsInCluster.begin() ; cellClusterIt != cellsInCluster.end(); ++cellClusterIt )
            { 
            //long int keyId=(*cellClusterIt).first;
            CellG *cell=(*cellClusterIt).second;           
            bptAccessorPtr=boundaryPixelTrackerPlugin->getBoundaryPixelTrackerAccessorPtr();
            set<BoundaryPixelTrackerData> & pixSetRef=bptAccessorPtr->get(cell->extraAttribPtr)->pixelSet;
            for (set<BoundaryPixelTrackerData>::iterator sitr=pixSetRef.begin(); sitr!=pixSetRef.end(); ++sitr)
                {
                Point3D pixel=Point3D((*sitr).pixel);
                PixelTrackerData pt;
                pt=PixelTrackerData(pixel);
                pixelsInMembrane.insert(pt);
                }
            if (listVesicleCandidates)
                {
                if ((cell->type==automaton->getTypeId("basolat")) || (cell->type==automaton->getTypeId("apical")))
                    {   
                    pixelTrackerAccessorPtr=pixelTrackerPlugin->getPixelTrackerAccessorPtr();
                    set<PixelTrackerData> cellPixels=pixelTrackerAccessorPtr->get(cell->extraAttribPtr)->pixelSet;   
                
                    //iterate over all the pixels in the cell and store the pixel in notAtMembrane if the pixel is not in pixelsInMembrane
                    set<PixelTrackerData>::iterator cellPixelsIt;
                    for ( cellPixelsIt = cellPixels.begin();cellPixelsIt != cellPixels.end(); ++cellPixelsIt)
                        {
                        PixelTrackerData pixelData;
                        pixelData=*cellPixelsIt;
                                           
                        if ((pixelsInMembrane.find(pixelData)) == pixelsInMembrane.end())
                            notAtMembrane.insert(pixelData);
                        }
                    }
                }
            }
        }
    else if (cellsInCluster.size()>1) //cell is polarized, thus have to find clusterborder
        {  
        map<long int,CellG*>::iterator cellInClusterIt;    
        for ( cellInClusterIt=cellsInCluster.begin() ; cellInClusterIt != cellsInCluster.end(); ++cellInClusterIt )
            {
            //cerr<<"3*****************pixelsInMembrane10************clusterId="<<ownClusterId<<endl;
            //long int keyId=(*cellInClusterIt).first;
            CellG *cell=(*cellInClusterIt).second; 
            //cerr<<"3*****************pixelsInMembrane10************cell="<<cell<<endl;
            //cerr<<"3*****************pixelsInMembrane10************cellid="<<cell->id<<" vol "<<cell->volume<<endl;
            //acces boundaryPixelTrackerPlugin
            bptAccessorPtr=boundaryPixelTrackerPlugin->getBoundaryPixelTrackerAccessorPtr();
            set<BoundaryPixelTrackerData> & pixSetRef=bptAccessorPtr->get(cell->extraAttribPtr)->pixelSet;
           
            //iterate over pixels in cluster and check their neighbors. If a neighbor is of type Medium or has a different clusterId, then the pixel is at the membrane 
            for (set<BoundaryPixelTrackerData>::iterator sitr=pixSetRef.begin();sitr!=pixSetRef.end();++sitr)
                {
                
                Point3D pixelData;
                pixelData=Point3D((*sitr).pixel);
                PixelTrackerData pixelTrackerData=PixelTrackerData(pixelData);		    
                Neighbor neighbor;
                //cerr<<"3*****************pixelsInMembrane10************13="<<cell<<endl;
                for(unsigned int nIdx=0 ; nIdx <= maxNeighborIndex ; ++nIdx) //iterate over the 8 nearest neighbors
                    {
                    neighbor=boundaryStrategy->getNeighborDirect(pixelData,nIdx);
                    if(!neighbor.distance)
                        {
                        //if distance is 0 then the neighbor returned is invalid
                        continue;
                        }
                    CellG *nCell;
                    nCell = fieldG->get(neighbor.pt);
                    if (pixelsInMembrane.find(pixelTrackerData) == pixelsInMembrane.end())
                        {
                        if (nCell) //neighbor not medium
                            { 
                            if (nCell->clusterId != cell->clusterId) //neighbor is different cluster thus pixel is at membrane 
                                {
                                pixelsInMembrane.insert(pixelTrackerData);
                                }
                            }
                        
                        else //neighbor is medium thus pixel is at membrane 
                            {                    
                            pixelsInMembrane.insert(pixelTrackerData);
                            //cerr<<"3*****************pixelsInMembrane14************="<<endl;
                            }
                        }
                    } 
                }
            if (listVesicleCandidates)
                {
                if ((cell->type==automaton->getTypeId("basolat")) || (cell->type==automaton->getTypeId("apical")))
                    {   
                    pixelTrackerAccessorPtr=pixelTrackerPlugin->getPixelTrackerAccessorPtr();
                    set<PixelTrackerData> cellPixels=pixelTrackerAccessorPtr->get(cell->extraAttribPtr)->pixelSet;
                          
                    //iterate over all the pixels in the cell and store the pixel in notAtMembrane if the pixel is not in pixelsInMembrane
                    set<PixelTrackerData>::iterator cellPixelsIt;
                    for ( cellPixelsIt = cellPixels.begin();cellPixelsIt != cellPixels.end(); ++cellPixelsIt)
                        {
                        PixelTrackerData pixelData;
                        pixelData=*cellPixelsIt;  
                        //cerr<<"PIXELS IN CELL="<<pixelData<<endl;              
                        if ((pixelsInMembrane.find(pixelData)) == pixelsInMembrane.end())
                            notAtMembrane.insert(pixelData);
                        }
                    }
                }
            }
        }
        //cerr<<"End pixelmembr="<<endl; 
        //assign the data to a typedef struct
        membraneData returnStruct;
        returnStruct.membranePixelSet=pixelsInMembrane;
        returnStruct.insidePixelSet=notAtMembrane;
        return returnStruct;
}


void MembranePolarizationFluidSteppable::vesicleSecretion(long int ownClusterId)
{   // cerr<<"4*****************vesicleSecretion************="<<endl;
    // for the pixels in the membrane of type vesicle or vacuole, find the connected neighbors and finallly secrete them 9turn inot medium)
    
    set<PixelTrackerData> membranePixelList = (pixelsInMembrane(ownClusterId, false)).membranePixelSet; //make a list of the pixels in membrane before vesicle secretion
    set<Point3D> toCheckList; 
    set<Point3D> secreteVesicleBlobList;

    set<PixelTrackerData>::iterator membranePixelIt;  
    map<Point3D,set<Point3D> > lumenfluidFusionMap;
    for ( membranePixelIt=membranePixelList.begin() ; membranePixelIt != membranePixelList.end(); ++membranePixelIt )
        {
        PixelTrackerData pixelTrData= *membranePixelIt; 
        Point3D pixelData=Point3D(pixelTrData.pixel);
        //cerr<<"pixelInMembrane="<<pixelData<<endl;
        
        CellG *pixelCell=fieldG->get(pixelData);
        if ((pixelCell->type==automaton->getTypeId("vesicle"))||(pixelCell->type==automaton->getTypeId("vacuole")))
            { 
            if (secreteVesicleBlobList.find(pixelData) == secreteVesicleBlobList.end()) 
                {
                if ( lumenfluidFusionMap.find(pixelData) == lumenfluidFusionMap.end() ) 
                    {
                    set<Point3D> cellsToFuse;
                    lumenfluidFusionMap.insert( pair < Point3D,set<Point3D> >((pixelData),cellsToFuse));
                    }    
                toCheckList.insert(pixelData); //for neighbors also secreted
                }
            while (!toCheckList.empty())
                {
                Point3D checkPixel=*toCheckList.begin();	
                toCheckList.erase(checkPixel);
                secreteVesicleBlobList.insert(checkPixel);
                Neighbor neighbor;
                for(unsigned int nIdx=0 ; nIdx <= maxVesicleNeighborIndex ; ++nIdx) //iterate over the 8 nearest neighbors
                    {              
                    neighbor=boundaryStrategy->getNeighborDirect(checkPixel,nIdx);
                    if(!neighbor.distance)
                        {
                        //if distance is 0 then the neighbor returned is invalid
                        continue;
                        }
                    CellG *nCell;
                    nCell = fieldG->get(neighbor.pt);
                    if (nCell)
                        {
                        if (((nCell->type==automaton->getTypeId("vesicle"))||(nCell->type==automaton->getTypeId("vacuole"))) && (pixelCell->clusterId == nCell->clusterId))
                            {
                            if (secreteVesicleBlobList.find(neighbor.pt) == secreteVesicleBlobList.end()) 
                                {
                                toCheckList.insert(neighbor.pt);
                                if ( lumenfluidFusionMap.find(pixelData) == lumenfluidFusionMap.end() ) 
                                        {
                                        set<Point3D> cellsToFuse;
                                        cellsToFuse.insert(neighbor.pt);
                                        lumenfluidFusionMap.insert( pair < Point3D,set<Point3D> >((pixelData),cellsToFuse));
                                        }
                                    //if clusterId is in list, than ask for the celllist and add this cell, give this as key
                                else
                                    {
                                    set<Point3D> cellsToFuse=lumenfluidFusionMap.find(pixelData)->second;
                                    cellsToFuse.insert(neighbor.pt);
                                    lumenfluidFusionMap[pixelData]=cellsToFuse;
                                    }  
                                }
                            }
                        }
                    }
                }
            }
        }
    
    //first pixel becomes lumenfluid cell with new clusterId, rest fused to that. Will fuse to neighboring lumenfluid in fusion and movement steppable 
     //if recevingcell has positive targetvolume, we can substrac 1 for secretion, otherwise do nothing and tv 0 is added to lumenfluid. If cell->vol=1 the cell will disappear thus tv larger than 1 must be added to fluid and ustracted from clustercell. 
    map<Point3D,set<Point3D> >::iterator lumenfluidFusionMapIt;
    for ( lumenfluidFusionMapIt=lumenfluidFusionMap.begin() ; lumenfluidFusionMapIt != lumenfluidFusionMap.end(); ++lumenfluidFusionMapIt )
        {
        Point3D receivingPixel= (*lumenfluidFusionMapIt).first;
        CellG* receivingCell=NULL;
        receivingCell = fieldG->get(receivingPixel);
        //cerr<<"receivingCellvol"<<receivingCell->volume<<" receivingCell Tvol"<<receivingCell->targetVolume<<" receivingcell type="<<(int)receivingCell->type<<endl;
        double targetVolumeToAdd=0.0;
        if (receivingCell->targetVolume>0.0)
            {
            targetVolumeToAdd=1.0;
            
            if (receivingCell->volume==1)
                {
                targetVolumeToAdd=receivingCell->targetVolume;
                }   
            receivingCell->targetVolume-=1;      
            }  
        //make lumenfluid with new clusterID and clusterID volume
        CellG* lumenFluidCell=NULL;
        lumenFluidCell=potts->createCellG(receivingPixel); //create   
        //cerr<<"Created LUMENfluidCell"<<lumenFluidCell<<" clusterId="<<lumenFluidCell->clusterId<<endl;            
        lumenFluidCell->type=automaton->getTypeId("lumenfluid"); //set type
        clusterDataTrackerPlugin->insertCellInCluster(lumenFluidCell);
        potts->runSteppers();   
        
        set<Point3D> cellsToFuse=(*lumenfluidFusionMapIt).second;
        set<Point3D> ::iterator cellsToFuseIt;
        for ( cellsToFuseIt=cellsToFuse.begin() ; cellsToFuseIt != cellsToFuse.end(); ++cellsToFuseIt )
            {
            Point3D fusePixel= *cellsToFuseIt;              
            fieldG->set(fusePixel,lumenFluidCell);     
            potts->runSteppers();
            //cerr<<"fuse pixel"<<fusePixel<<" to lumenfluidCell clusterid="<<lumenFluidCell->clusterId<<endl;
                    
            }
        //for receivingcell changed into lumenfluid. CTD.h cv +1 and in CTD.cpp cv +1 and -1 and if has more pixels will be handeld in fuse in CTD.cpp, other here
        //cerr<<"targetVolumeToAdd="<<targetVolumeToAdd<<endl;
        clusterDataTrackerPlugin->addClusterTargetVolume(ownClusterId, -targetVolumeToAdd);
        clusterDataTrackerPlugin->addClusterTargetVolume(lumenFluidCell->clusterId, targetVolumeToAdd);
   
        }  

} 


set<PixelTrackerData> MembranePolarizationFluidSteppable::pixelsToBasolTypeList(membraneData cellMembraneData , long ownClusterId)
{ //to make a list of the pixels in the membrane that should become of type basolat because they have a neighbor of type fibrin
    //cerr<<"8*****************pixelsToBasolTypeList************="<<endl;
    //get membrane pixels from list and check their second order neighbors. If their neighbor is of type fibrin, the pixel will be added to the 'become basal' list. 
    set<PixelTrackerData> pixelsInMembraneList=cellMembraneData.membranePixelSet;
    //int toBasolCount=0;     
    set<PixelTrackerData> pixelsToBasolType;
    pixelsToBasolType.clear();
    set<PixelTrackerData>::iterator pixelDataIt; 
    for ( pixelDataIt = pixelsInMembraneList.begin(); pixelDataIt != pixelsInMembraneList.end(); ++pixelDataIt )
        {
        PixelTrackerData pixelTrData= *pixelDataIt; 
        Point3D pixelData=Point3D(pixelTrData.pixel);
        Neighbor neighbor;
        for(unsigned int nIdx=0 ; nIdx <= maxNeighborIndex ; ++nIdx) //iterate over the 8 nearest neighbors
            {
	    neighbor=boundaryStrategy->getNeighborDirect(pixelData,nIdx);
            if(!neighbor.distance)
                {
		//if distance is 0 then the neighbor returned is invalid
		continue;
		}
            CellG *nCell;
            nCell = fieldG->get(neighbor.pt);
            if (nCell)
                {
                if (nCell->type == automaton->getTypeId("fibrin")) //neighbor is of type fibrin, thus pixel must be stored in to become basolat list
                    {
                    pixelsToBasolType.insert(pixelTrData);
                    //toBasolCount+=1;
                    }                   
                }
            }
        }

    return pixelsToBasolType;
}
MembranePolarizationFluidSteppable::membraneData MembranePolarizationFluidSteppable::MPbyBM(long int ownClusterId, membraneData cellMembraneData)
{  
   //cerr<<"1*****************MPbyBM************="<<endl; 
    set<PixelTrackerData> pixelsInMembraneList=cellMembraneData.membranePixelSet;
    set<PixelTrackerData> notAtMembraneList=cellMembraneData.insidePixelSet;
    set<PixelTrackerData> pixelListToBasol=pixelsToBasolTypeList(cellMembraneData, ownClusterId); //store the pixelcoordinates at the membrane that have to become basolateral, since they have neighbors of type fibrin  
    cellMembraneData.pixelsToBasolType=pixelListToBasol;
    
    bool has_basol=false ; 
    CellG* basolatCell=NULL;
    CellG* apicalCell=NULL;
  
    set<PixelTrackerData>::iterator membranePixelIt; 
    for ( membranePixelIt = pixelsInMembraneList.begin(); membranePixelIt != pixelsInMembraneList.end(); ++membranePixelIt )
        {
        PixelTrackerData membranePixelTrData= *membranePixelIt; 
        Point3D membranePixel=Point3D(membranePixelTrData.pixel);
        CellG *membranePixelCell=fieldG->get(membranePixel);

        //First the membrane pixels are converted to basolat if they are in the pixelsToBasolTypeList.
        if (pixelListToBasol.find(membranePixelTrData) != pixelListToBasol.end())
            { 
            bool polarizePixel=probabilityPolarization(cellMembraneData,membranePixelCell, 'b');
            if (polarizePixel)
                {
                //A basolat cell is created if none existed  
                basolatCell=clusterDataTrackerPlugin->getBasolateralCell(ownClusterId);         
                if (!basolatCell) //no basolatcell existing yet in this cluster, thus create one 
                    {
                    basolatCell=potts->createCellG(membranePixel,ownClusterId); //create               
                    basolatCell->type=automaton->getTypeId("basolat"); //set type
                    potts->runSteppers();   
                    clusterDataTrackerPlugin->insertCellInCluster(basolatCell);
                    has_basol=true;
                    }             
                 
                 //otherwise the pixel is fused to the existing basolat cell in the cluster.
                 else 
                    {
                    has_basol=true;                
                    if (!(membranePixelCell->type==automaton->getTypeId("basolat")))
                        {                         
                        fieldG->set(membranePixel,basolatCell); 
                        potts->runSteppers(); 
                        }
                    }
                }
            }
        }
    if (has_basol) //if cell has polarized into basolat, we also need polarization of membrane pixels into apical
        {  
        set<PixelTrackerData>::iterator apicalPixelIt; 
        for (apicalPixelIt = pixelsInMembraneList.begin();apicalPixelIt != pixelsInMembraneList.end(); ++apicalPixelIt )
            {
            PixelTrackerData apicalPixelTrData= *apicalPixelIt; 
            Point3D apicalPixel=Point3D(apicalPixelTrData.pixel);
            CellG *apicalPixelCell=fieldG->get(apicalPixel); 
            if (pixelListToBasol.find(apicalPixelTrData) == pixelListToBasol.end()) //if not in this list, then become apical
                { 
                bool polarizeApicalPixel=probabilityPolarization(cellMembraneData,apicalPixelCell, 'a');
                if (polarizeApicalPixel)
                    {             
                    apicalCell=clusterDataTrackerPlugin->getApicalCell(ownClusterId);         
                    if (!apicalCell) //no apicalcell existing yet in this cluster, thus create one 
                        {
                        apicalCell=potts->createCellG(apicalPixel,ownClusterId);               
                        apicalCell->type=automaton->getTypeId("apical");
                        potts->runSteppers();
                        clusterDataTrackerPlugin->insertCellInCluster(apicalCell);
                        }

                    else//apical cell exist, fuse this pixel to that cell
                        {
                        if (!(apicalPixelCell->type==automaton->getTypeId("apical")))
                            {
                            fieldG->set(apicalPixel,apicalCell);
                            potts->runSteppers();
                            }
                        }
                    }
                }
            } 
        }
       //cerr<<"1*****************MP************=2"<<endl;         
    cellMembraneData.polarization=has_basol;
    return cellMembraneData ;

}
    


void MembranePolarizationFluidSteppable::vesicleCreation(long ownClusterId, membraneData cellMembraneData)
{ //to convert pixels of type baslat or apical to vesicle when they are no longer at the membrane, but are internalized in the cell
    //cerr<<"7*****************pixelsToVesicle************="<<endl;

    set<PixelTrackerData> notAtMembrane=cellMembraneData.insidePixelSet;
    set<PixelTrackerData> membranePixelsList=cellMembraneData.membranePixelSet;
    CellG *newVesicleCell=NULL;
    CellG *cytoplasmCell=NULL;
    // iterate over the pixels of the cluster that are not at the membrane. 
    set<PixelTrackerData>::iterator insidePixelIt;   
    for ( insidePixelIt=notAtMembrane.begin() ; insidePixelIt != notAtMembrane.end(); ++insidePixelIt )
        {
        PixelTrackerData insidePixelTrData= *insidePixelIt; 
        Point3D pixelData=Point3D(insidePixelTrData.pixel);
        CellG *pixelCell=fieldG->get(pixelData);
        //if the pixel is of type basolat, it should become of type vesicle. If there is no vesicle in the cluster yet or it has no volume, create one. Else, fuse the pixel to the existing one. 
        bool nextToMembrane=false;
        Neighbor neighbor;
        for(unsigned int nIdx=0 ; nIdx <= maxNeighborIndex ; ++nIdx) //iterate over the 8 nearest neighbors
            {                
            neighbor=boundaryStrategy->getNeighborDirect(pixelData,nIdx);
            if(!neighbor.distance)
                {
                //if distance is 0 then the neighbor returned is invalid
                continue;
                }
            if (membranePixelsList.find(PixelTrackerData(neighbor.pt)) != membranePixelsList.end())//pixel next to membrane
                nextToMembrane=true;
            }
        //cerr<<"7*****************pixelsToVesicle************=1"<<endl;
        if (!nextToMembrane)
            {
            bool pixelToVesicle=probabilityPolarization(cellMembraneData,pixelCell, 'v');
            if (pixelToVesicle)
                {
                //cerr<<"CREATE VEsicle"<<endl;        
                newVesicleCell=potts->createCellG(pixelData,ownClusterId); //create cell at this pixel           
                newVesicleCell->type=automaton->getTypeId("vesicle"); //give the cell type vesicle
                newVesicleCell->targetVolume=vesicleTargetVolume;
                newVesicleCell->lambdaVolume=vesicleLambdaVolume;
                potts->runSteppers(); 
                clusterDataTrackerPlugin->insertCellInCluster(newVesicleCell);
                clusterDataTrackerPlugin->adjustClusterTargetVolumeAfterVesicleAddition(newVesicleCell); //because potts->runsteppers gives newcell=0 to tracker, so not read in as vesicle               
                }    
            else //vesicle not accepted and becomes original celltype
                {
                //cerr<<"7*****************pixelsToVesicle************=2"<<endl;
                cytoplasmCell=clusterDataTrackerPlugin->getCytoplasmCell(ownClusterId);
                //cerr<<"7*****************pixelsToVesicle************=3"<<endl;
                if (!cytoplasmCell) //no cytoplasm cell existing yet in this cluster, thus create one 
                    { 
                     //cerr<<"7*****************pixelsToVesicle************=4"<<endl;
                    cytoplasmCell=potts->createCellG(pixelData,ownClusterId);               
                    cytoplasmCell->type=automaton->getTypeId("cell");
                    potts->runSteppers();
                    clusterDataTrackerPlugin->insertCellInCluster(cytoplasmCell);
                    }
                   
                else//original cell exist, fuse this pixel to that cell
                    { 
                    //cerr<<"7*****************pixelsToVesicle************=5"<<endl;   
                    fieldG->set(pixelData,cytoplasmCell);
                    potts->runSteppers();
                    //cerr<<"7*****************pixelsToVesicle************=5"<<endl;   
                    }
                }
            }
        else //do not become vesicle, but become original celltype again.
            {
            //cerr<<"7*****************pixelsToVesicle************=7"<<endl;
            cytoplasmCell=clusterDataTrackerPlugin->getCytoplasmCell(ownClusterId);
            //cerr<<"7*****************pixelsToVesicle************=8"<<endl;
            if (!cytoplasmCell) //no cytoplasm cell existing yet in this cluster, thus create one 
                {  
                  //cerr<<"7*****************pixelsToVesicle************=9"<<endl;  
                cytoplasmCell=potts->createCellG(pixelData,ownClusterId);               
                cytoplasmCell->type=automaton->getTypeId("cell");
                potts->runSteppers();
                clusterDataTrackerPlugin->insertCellInCluster(cytoplasmCell);
                }
               
            else//original cell exist, fuse this pixel to that cell
                { 
                //cerr<<"7*****************pixelsToVesicle************=10"<<endl;  
                fieldG->set(pixelData,cytoplasmCell);
                potts->runSteppers();
               // cerr<<"7*****************pixelsToVesicle************=11"<<endl;
                }
            }                   
                    
        }   
           
}




       
bool MembranePolarizationFluidSteppable::twoBasolNeigh(Point3D point, long clusterId)
{ //to list the pixels in the membrane that ar apical but need to become basolat because they have two neighbors of type basolat of their own clusterId
    //cerr<<"9*****************twoBasolNeigh************="<<endl;
    Neighbor neighbor;
    CellG *nCell;
    bool type_basol_ownCluster_twice = false; //becomes true if the pixel has two neighbors of type basolat from the same cluster, this pixel will later become basolat as well
    int type_basol_ownCluster_count=0;

    for(unsigned int nIdx=0 ; nIdx <= maxNeighborIndex ; ++nIdx )
        {
        neighbor=boundaryStrategy->getNeighborDirect(point,nIdx);
        if(!neighbor.distance)
            {
	    //if distance is 0 then the neighbor returned is invalid
	    continue;
	    }
        
        nCell = fieldG->get(neighbor.pt);
        if (nCell)
            {
            if (nCell->clusterId==clusterId)
                {
                if (nCell->type==automaton->getTypeId("basolat"))
                    {
                    type_basol_ownCluster_count+=1;
                    }
                }
            }
         }
    if (type_basol_ownCluster_count>=2) 
        type_basol_ownCluster_twice = true;
    return type_basol_ownCluster_twice;
}
 
void MembranePolarizationFluidSteppable::MPlateral(long ownClusterId, membraneData cellMembraneData)
{
    //cerr<<"2*****************MPlateral************="<<endl;
    set<PixelTrackerData> pixelsInMembraneList=cellMembraneData.membranePixelSet;
    set<PixelTrackerData> pixelListToBasol=cellMembraneData.pixelsToBasolType;
    //some membrane pixels that are now apical should be basolat if they have two or more neighbors of basolat type of their own clusterId    
    bool check_pixel_to_basol=false;
    set<PixelTrackerData>::iterator checkPixelIt; 
    set<Point3D> fuseToBasol; 
    for ( checkPixelIt = pixelsInMembraneList.begin();
       checkPixelIt != pixelsInMembraneList.end(); ++checkPixelIt )
        { 
        PixelTrackerData checkPixelTrData= *checkPixelIt; 
        Point3D checkPixel=Point3D(checkPixelTrData.pixel);           
        CellG *checkPixelCell=fieldG->get(checkPixel);
        if (pixelListToBasol.find(checkPixelTrData) == pixelListToBasol.end()) //not in list, thus apical pixel
            {                
            check_pixel_to_basol=twoBasolNeigh(checkPixel, ownClusterId); //if two or more neigh of own basolat type, fude apical pixel to basolat cell  
            if (check_pixel_to_basol)
                {
                bool polarizeCheckPixel=probabilityPolarization(cellMembraneData,checkPixelCell, 'b');
                if (polarizeCheckPixel)
                    {
                    if (!(checkPixelCell->type==automaton->getTypeId("basolat")))
                        {
                        fuseToBasol.insert(checkPixel); 
                        }
                    }
                }
            }
        }
  

    // convert form apical to basolat since they had two basolat neighbors
    CellG* basolatCell=clusterDataTrackerPlugin->getBasolateralCell(ownClusterId);
    set<Point3D>::iterator fuseCheckPixelIt; 
    for ( fuseCheckPixelIt = fuseToBasol.begin();
       fuseCheckPixelIt != fuseToBasol.end(); ++fuseCheckPixelIt )
        {
        //cerr<<"2*****************MPlateral************=1"<<endl;
        Point3D fuseCheckPixel =  *fuseCheckPixelIt;
        fieldG->set(fuseCheckPixel,basolatCell);
       
        potts->runSteppers();
        //cerr<<"2*****************MPlateral************=2"<<endl;
        }
    
}

void MembranePolarizationFluidSteppable::depolarization(long ownClusterId, membraneData cellMembraneData)
{
    //cerr<<"3*****************depolarization************="<<endl;
    CellG* cytoplasmCell=NULL;
    set<PixelTrackerData> pixelsInMembraneList=cellMembraneData.membranePixelSet;
    set<PixelTrackerData>::iterator membraneDepolarizePixelIt;
    for ( membraneDepolarizePixelIt = pixelsInMembraneList.begin(); membraneDepolarizePixelIt != pixelsInMembraneList.end(); ++membraneDepolarizePixelIt )
        {
        PixelTrackerData membraneDepolarizePixelTrData= *membraneDepolarizePixelIt; 
        Point3D membraneDepolarizePixel=Point3D(membraneDepolarizePixelTrData.pixel);      
        CellG *membraneDepolarizeCell=fieldG->get(membraneDepolarizePixel);
        bool depolarizePixel=probabilityPolarization(cellMembraneData,membraneDepolarizeCell, 'c');
        if (depolarizePixel)
            { 
            cytoplasmCell=clusterDataTrackerPlugin->getCytoplasmCell(ownClusterId);         
            if (!cytoplasmCell) //no cytoplasm cell existing yet in this cluster, thus create one 
                {                 
                cytoplasmCell=potts->createCellG(membraneDepolarizePixel,ownClusterId);               
                cytoplasmCell->type=automaton->getTypeId("cell");
                potts->runSteppers();
                clusterDataTrackerPlugin->insertCellInCluster(cytoplasmCell);
                }                

            else//original cell exist, fuse this pixel to that cell
                {    
                fieldG->set(membraneDepolarizePixel,cytoplasmCell);
                potts->runSteppers();
                }

            }
        }
}






void MembranePolarizationFluidSteppable::update(CC3DXMLElement *_xmlData, bool _fullInitFlag){
//cerr<<"13*****************update************="<<endl;

      if(_xmlData->findElement("initializingStep"))
        initializingStep=_xmlData->getFirstElement("initializingStep")->getDouble();
    else
        initializingStep=0.0;  
    
    if(_xmlData->findElement("VesicleTargetVolume"))
        vesicleTargetVolume=_xmlData->getFirstElement("VesicleTargetVolume")->getDouble();
    if(_xmlData->findElement("VesicleLambdaVolume"))
        vesicleLambdaVolume=_xmlData->getFirstElement("VesicleLambdaVolume")->getDouble();

    //probabilities of conversions
	if(_xmlData->findElement("pBtoV"))
		pBtoV=_xmlData->getFirstElement("pBtoV")->getDouble();
	if(_xmlData->findElement("pAtoV"))
        pAtoV=_xmlData->getFirstElement("pAtoV")->getDouble();
	if(_xmlData->findElement("pCtoA"))
        pCtoA=_xmlData->getFirstElement("pCtoA")->getDouble();
	if(_xmlData->findElement("pCtoB"))
        pCtoB=_xmlData->getFirstElement("pCtoB")->getDouble();
	if(_xmlData->findElement("pAtoA"))
        pAtoA=_xmlData->getFirstElement("pAtoA")->getDouble();
	if(_xmlData->findElement("pBtoB"))
        pBtoB=_xmlData->getFirstElement("pBtoB")->getDouble();
	if(_xmlData->findElement("pAtoB"))
        pAtoB=_xmlData->getFirstElement("pAtoB")->getDouble();
	if(_xmlData->findElement("pBtoA"))
        pBtoA=_xmlData->getFirstElement("pBtoA")->getDouble();
	if(_xmlData->findElement("pVtoA"))
        pVtoA=_xmlData->getFirstElement("pVtoA")->getDouble();
	if(_xmlData->findElement("pVtoB"))
        pVtoB=_xmlData->getFirstElement("pVtoB")->getDouble();
	if(_xmlData->findElement("pAtoC"))
        pAtoC=_xmlData->getFirstElement("pAtoC")->getDouble();
	if(_xmlData->findElement("pBtoC"))
        pBtoC=_xmlData->getFirstElement("pBtoC")->getDouble(); 
	if(_xmlData->findElement("pVtoC"))
        pVtoC=_xmlData->getFirstElement("pVtoC")->getDouble();     

    //rand function for probobality funtion, is class
    rand = BasicRandomNumberGenerator::getInstance();
    //if(_xmlData->getFirstElement("RandomSeed"))
    //    rand->setSeed(_xmlData->getFirstElement("RandomSeed")->getInt()); 
 
    //Here I initialize max neighbor index for direct acces to the list of neighbors, but does not work yet, do not knwo why 
    boundaryStrategy=BoundaryStrategy::getInstance();
    maxNeighborIndex=0;
    if(_xmlData->getFirstElement("Depth"))
        maxNeighborIndex=boundaryStrategy->getMaxNeighborIndexFromDepth(_xmlData->getFirstElement("Depth")->getDouble());
    else
        {
	//cerr<<"got here will do neighbor order"<<endl;
	if(_xmlData->getFirstElement("NeighborOrder"))
	    maxNeighborIndex=boundaryStrategy->getMaxNeighborIndexFromNeighborOrder(_xmlData->getFirstElement("NeighborOrder")->getUInt());	
	else
	    maxNeighborIndex=boundaryStrategy->getMaxNeighborIndexFromNeighborOrder(1);
        }
		
    if(_xmlData->getFirstElement("VesicleNeighborOrder"))
	maxVesicleNeighborIndex=boundaryStrategy->getMaxNeighborIndexFromNeighborOrder(_xmlData->getFirstElement("VesicleNeighborOrder")->getUInt());			
    else
	maxVesicleNeighborIndex=maxNeighborIndex;
	
    cerr<<"######membraneStepp pBtoV="<<pBtoV<<endl;
    //cerr<<"######membraneStepp ClusterTargetVolume="<<clusterTargetVolume<<endl;
    cerr<<"######membraneStepp maxNeighborIndex="<<maxNeighborIndex<<endl;
    cerr<<"######RAND="<<rand<<endl;
}

std::string MembranePolarizationFluidSteppable::toString(){
   return "MembranePolarizationFluidSteppable";
}


std::string MembranePolarizationFluidSteppable::steerableName(){
   return toString();
}

